--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--

rollout DYNattachParams ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCobject
  local LOCobjectController
  local LOCspinStartValue
  local LOCundoState = on

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNattachParams FUNobject =
  (
    if DYNattachParams.open then
    (
      DYNattachParams.PKDYNpar.pos.y   += -4
      DYNattachParams.BUDYNnoPar.pos.y += -4

      if isValidNode FUNobject then
      (
        DYNattachParams.LOCobject       = FUNObject
        DYNattachParams.SPDYNhOff.value = FUNobject.objectOffsetPos.x
        DYNattachParams.SPDYNvOff.value = FUNobject.objectOffsetPos.z
        DYNattachParams.SPDYNchn.value  = FUNobject.objectOffsetPos.y
        DYNattachParams.SPDYNrot.value  = in coordsys parent (FUNobject.rotation.z_rotation)

        if isValidNode FUNobject.parent then
        (
          DYNattachParams.PKDYNpar.text = FUNobject.parent.name
        )
      )
    )
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  groupbox GBDYNgroup01 width:(DYNiniExplorerWidth - 21) pos:[4,7]   height:50
  pickbutton PKDYNpar width:(DYNINIexplorerWidth - 55) align:#center filter:DYNFUNgeometryLightFilter pos:[15,30]
  button BUDYNnoPar DYNuiResourcesButtons[22] width:15 pos:[(DYNINIexplorerWidth - 39),30]

  groupbox GBDYNgroup02 width:(DYNiniExplorerWidth - 21) pos:[4,62]   height:104
  label   LBDYNchn  align:#left                                                            pos:[11,81]  width:110
  spinner SPDYNchn  type:#worldunits   range:[-9999.0,9999.0,0.0] scale:0.1 fieldwidth:48  pos:[(DYNiniExplorerWidth - 84),81]

  label   LBDYNhOff align:#left                                                            pos:[11,102] width:110
  spinner SPDYNhOff type:#worldunits   range:[-9999.0,9999.0,0.0] scale:0.1 fieldwidth:48  pos:[(DYNiniExplorerWidth - 84),102]

  label   LBDYNvOff align:#left                                                            pos:[11,123] width:110
  spinner SPDYNvOff type:#worldunits   range:[-9999.0,9999.0,0.0] scale:0.1 fieldwidth:48  pos:[(DYNiniExplorerWidth - 84),123]

  label   LBDYNrot  align:#left                                                            pos:[11,144] width:110
  spinner SPDYNrot  type:#float   range:[-360.0,360.0,0.0] scale:0.1 fieldwidth:48         pos:[(DYNiniExplorerWidth - 84),144]

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNattachParams open do
  (
    DYNattachParams.title = DYNuiRolloutNames[7]
    GBDYNgroup01.text = DYNuiResourcesGroups[18]
    GBDYNgroup02.text = DYNuiResourcesGroups[19]
    BUDYNnoPar.text   = DYNuiResourcesButtons[22]
    LBDYNchn.text     = DYNuiResourcesLabels[78]
    LBDYNhOff.text    = DYNuiResourcesLabels[1]
    LBDYNvOff.text    = DYNuiResourcesLabels[2]
    LBDYNrot.text     = DYNuiResourcesLabels[79]
  )

  on DYNattachParams close do
  (
    LOCobject = undefined
  )

  on PKDYNpar picked arg do
  (
    -- "if open" required to ensure that pickbutton is not still "picking" after panel closes
    if DYNattachParams.open do
    (
      if arg != undefined then
      (
        PKDYNpar.text = arg.name
        undo off DYNFUNattachObject arg LOCobject [SPDYNhOff.value * -1, SPDYNchn.value, SPDYNvOff.value] (in coordsys parent (LOCobject.rotation.z_rotation))
      )
    )
  )

  on BUDYNnoPar pressed do
  (
    local LOCwarning = if IsValidNode LOCobject.parent then (DYNuiResourcesQueries[4] + "\n\n" + LOCobject.parent.name) else (DYNuiResourcesQueries[5])
    if querybox LOCwarning title:DYNuiResourcesTitlebars[2] then
    (
      PKDYNpar.text        = DYNuiResourcesButtons[15]
      local LOCstrHoffset  = LOCobject.objectOffsetPos.x
      local LOCstrChainage = LOCobject.objectOffsetPos.y
      local LOCstrVoffset  = LOCobject.objectOffsetPos.z
      local LOCstrRotation = in coordsys parent (LOCobject.rotation.z_rotation)
      LOCstrHoffset  = 0.0
      LOCstrChainage = 0.0
      LOCstrVoffset  = 0.0
      LOCstrRotation = 0.0

      undo off
      (
        LOCobject.objectOffsetpos = [0,0,0]
        LOCobject.rotation.z_rotation = 0.0

        local LOCparController = LOCobject.parent.transform.controller
        DYNFUNapplyMaxTransform LOCobject LOCparController.path (100 * LOCparController.percent) (LOCparController.rotation + LOCstrRotation) (LOCparController.hOffset) (LOCparController.vOffset + LOCstrVoffset) LOCparController.followPath LOCparController.followSurface LOCparController.surface LOCparController.distance true LOCparController.spline --Set Up Path Controller for New Object

        LOCobject.parent = undefined

        --- Continue with main function
        select LOCobject
      )
    )
  )

  --- Chainage Spinner Control
  on SPDYNchn  changed arg do (with undo label:(DYNuiResourcesUndoLabels[2]) LOCundoState LOCobject.objectOffsetPos.y = arg)
  on SPDYNchn  buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNchn.value)
  on SPDYNchn  buttonUp    do
  (
    if LOCspinStartValue != SPDYNchn.value then
    (
      with undo off LOCobject.objectOffsetPos.y = LOCspinStartValue
      with undo label:(DYNuiResourcesUndoLabels[2]) on LOCobject.objectOffsetPos.y = SPDYNchn.value
    )
    LOCundoState    = on
  )

  --- Horizontal Offset Spinner Control
  on SPDYNhOff changed arg do (with undo label:(DYNuiResourcesUndoLabels[3]) LOCundoState LOCobject.objectOffsetPos.x = arg)
  on SPDYNhOff buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNhOff.value)
  on SPDYNhOff buttonUp    do
  (
    if LOCspinStartValue != SPDYNhOff.value then
    (
      with undo off LOCobject.objectOffsetPos.x = LOCspinStartValue
      with undo label:(DYNuiResourcesUndoLabels[3]) on LOCobject.objectOffsetPos.x = SPDYNhOff.value
    )
    LOCundoState    = on
  )

  --- Vertical Offset Spinner Control
  on SPDYNvOff changed arg do (with undo label:(DYNuiResourcesUndoLabels[4]) LOCundoState LOCobject.objectOffsetPos.z = arg)
  on SPDYNvOff buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNvOff.value)
  on SPDYNvOff buttonUp    do
  (
    if LOCspinStartValue != SPDYNvOff.value then
    (
      with undo off LOCobject.objectOffsetPos.z = LOCspinStartValue
      with undo label:(DYNuiResourcesUndoLabels[4]) on LOCobject.objectOffsetPos.z = SPDYNvOff.value
    )
    LOCundoState    = on
  )

  --- Rotation Spinner Control
  on SPDYNrot changed arg do (with undo label:(DYNuiResourcesUndoLabels[5]) LOCundoState (in coordsys parent (LOCobject.rotation.z_rotation = arg)))
  on SPDYNrot buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNrot.value)
  on SPDYNrot buttonUp    do
  (
    if LOCspinStartValue != SPDYNrot.value then
    (
      with undo off (in coordsys parent (LOCobject.rotation.z_rotation = LOCspinStartValue))
      with undo label:(DYNuiResourcesUndoLabels[5]) on (in coordsys parent (LOCobject.rotation.z_rotation = SPDYNrot.value))
    )
    LOCundoState    = on
  )
)
